/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  menu.c
//  Functions for the menu
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



/* This function shows the selected information on the display.
 * 1: show output voltage & output current
 * 2: show mains voltage & PFC voltage
 * 3: show switching frequency
 * 4: show heatsink temperature of PFC & Hbridge
 * 5: show chassis temperature */
void show_info(unsigned int menu_selection)
{
	// variables to show a number in the format XX.X or XXX (first, second, third digit)
	unsigned int first_digit, second_digit, third_digit;
	unsigned int i, PWM_out;
	
	
	// check if a fault is present
	if(status_supply > 10)	// fault present
	{
		LED_on; 			// enable error
		lcd_gotoxy(0,0); lcd_puts("ERROR           ");
		
		//	11:	output voltage too high
		//	12: mains voltage too low
		//	13: mains voltage too high
		//	14: PFC voltage too low
		//	15: PFC voltage too high
		//	16: chassis temperature too high
		//	17: PFC heatsink temperature too high
		//	18: Hbridge heatsink temperature too high
		//	19: output current too high
		switch(status_supply)
		{
			case(11):	lcd_gotoxy(0,1); lcd_puts("Vout      >14.9V");
						break;
			case(12):	lcd_gotoxy(0,1); lcd_puts("Vmains      <85V");
						break;
			case(13):	lcd_gotoxy(0,1); lcd_puts("Vmains     >265V");
						break;
			case(14):	lcd_gotoxy(0,1); lcd_puts("Vpfc       <385V");
						break;
			case(15):	lcd_gotoxy(0,1); lcd_puts("Vpfc       >400V");
						break;
			case(16):	lcd_gotoxy(0,1); lcd_puts("Tchassis   >65");
						lcd_puts("\xDF"); lcd_puts("C");
						break;
			case(17):	lcd_gotoxy(0,1); lcd_puts("Tpfc       >65");
						lcd_puts("\xDF"); lcd_puts("C");
						break;
			case(18):	lcd_gotoxy(0,1); lcd_puts("Thbridge   >65");
						lcd_puts("\xDF"); lcd_puts("C");
						break;
			case(19):	lcd_gotoxy(0,1); lcd_puts("Iout      >26.0A");
						break;
		}	
	} // if(status_supply > 10)
	
	else
	{	
		if(menu_config)	// show configuration menu
		{
			switch(menu_selection)
			{
				case 1: lcd_gotoxy(0,0); lcd_puts("CONFIGURATION   ");
						lcd_gotoxy(0,1); lcd_puts("Vout         . V");
						
						// 0% duty cycle: 14.0V, 100% duty cycle: 12.0V
						// "-": increase duty cycle, "+": decrease duty cycle
						// values have been measured
						// ref_voltage = 120 .. 140, equals 12.0 .. 14.0V
						if(key_minus_short)	// decrease duty cycle
						{
							ref_voltage = ref_voltage - 2;
						}
						
						// limit min. value to 120
						if(ref_voltage < 120)
							{
							ref_voltage = 120;
							}
						
						if(key_plus_short)	// increase duty cycle
						{
							ref_voltage = ref_voltage + 2;
						}
						
						// limit max. value to 140
						if(ref_voltage > 140)
						{
							ref_voltage = 140;
						}			
						
						// fragment the number of the selected output voltage
						i = ref_voltage;
						first_digit = i / 100;
						i = i % 100;
						second_digit = i / 10;
						third_digit = i % 10;

						// show selected voltage on display
						lcd_gotoxy(11,1);
						lcd_puti(first_digit); lcd_puti(second_digit);
						lcd_gotoxy(14,1); lcd_puti(third_digit);

						// choose timer value according to the selected voltage
						switch(ref_voltage)
						{
							case 120:	PWM_out = 160; break;
							case 122:	PWM_out = 130; break;
							case 124:	PWM_out = 110; break;
							case 126:	PWM_out = 93; break;
							case 128:	PWM_out = 76; break;
							case 130:	PWM_out = 59; break;
							case 132:	PWM_out = 42; break;
							case 134:	PWM_out = 25; break;
							case 136:	PWM_out = 9; break;
							case 138:	PWM_out = 1; break;
							case 140:	PWM_out = 0; break;
						}

						// update timer register
						if(TACCR2 != PWM_out)
						{
							TACCR2 = PWM_out;
						}
						break;	// case 1
				
				case 3: lcd_gotoxy(0,0); lcd_puts("CONFIGURATION   ");
						lcd_gotoxy(0,1); lcd_puts("fswitch      kHz");
						
						if(key_plus_short)	// increase switching frequency
						{
							// 2 steps equals a change of approx. 4.5 .. 5%
							threshold0_fswitch = threshold0_fswitch - 2;
						}
						
						// limit min. value to 44
						if(threshold0_fswitch < 44)
						{
							threshold0_fswitch = 44;
						}
						
						if(key_minus_short)	// decrease switching frequency
						{
							// 2 steps equals a change of approx. 4.5 .. 5%
							threshold0_fswitch = threshold0_fswitch + 2;
						}
	
						// limit max. value to 50
						if(threshold0_fswitch > 50)
							{
							threshold0_fswitch = 50;
							}
						
						// show voltage on display
						switch(threshold0_fswitch)
						{
							case 44:	i = 178; break;
							case 46:	i = 170; break;
							case 48:	i = 163; break;
							case 50:	i = 157; break;
						}
											
						// show selected frequency on display
						lcd_gotoxy(10,1); lcd_puti(i);
						
						// update timer registers
						if(TBCCR0 != threshold0_fswitch)
						{
							TBCCR0 = threshold0_fswitch;
							TBCCR1 = threshold0_fswitch / 2;
						}
						break;			
			}	// switch(menu_selection)
		}	// if(menu_config)
		
		else
		{
			
			switch(menu_selection)
			{
				case 1:	// show output voltage & output current
						// fragment the number of the output voltage
						first_digit = voltage_output / 100;
						i = voltage_output % 100;
						second_digit = i / 10;
						third_digit = i % 10;
						
						lcd_gotoxy(0,0); lcd_puts("Vout       ");
						if(first_digit > 0) lcd_puti(first_digit);
						else lcd_puts(" ");
						lcd_puti(second_digit); lcd_puts(".");
						lcd_puti(third_digit); lcd_puts("V");
						
						// fragment the number of the output current
						first_digit = current_output / 100;
						i = current_output % 100;
						second_digit = i / 10;
						third_digit = i % 10;	
						
						lcd_gotoxy(0,1); lcd_puts("Iout       ");
						if(first_digit > 0) lcd_puti(first_digit);
						else lcd_puts(" ");
						lcd_puti(second_digit); lcd_puts(".");
						lcd_puti(third_digit); lcd_puts("A");
						
						break;
				
				case 2:	// show mains voltage & PFC voltage
						// fragment the number of the mains voltage
						first_digit = voltage_mains / 100;
						i = voltage_mains % 100;
						second_digit = i / 10;
						third_digit = i % 10;
						
						lcd_gotoxy(0,0); lcd_puts("Vmains      ");
						
						// if I2C communication is disturbed, the voltage is set to 1000V
						if(voltage_mains == 1000)
						{
							lcd_puts("---V");
						}
						else
						{
							if(first_digit > 0) lcd_puti(first_digit);
							else lcd_puts(" ");
							lcd_puti(second_digit);
							lcd_puti(third_digit); lcd_puts("V");
						}
						
						// fragment the number of the PFC voltage
						first_digit = voltage_pfc / 100;
						i = voltage_pfc % 100;
						second_digit = i / 10;
						third_digit = i % 10;	
						
						lcd_gotoxy(0,1); lcd_puts("Vpfc        ");
						
						// if I2C communication is disturbed, the voltage is set to 1000V
						if(voltage_pfc == 1000)
						{
							lcd_puts("---V");
						}
						else
						{
							if(first_digit > 0) lcd_puti(first_digit);
							else lcd_puts(" ");
							lcd_puti(second_digit);
							lcd_puti(third_digit); lcd_puts("V");
						}
						break;
				
				case 3:	// show switching frequency
						// select switching frequency
						switch(threshold0_fswitch)
						{
							case 44:	i = 178; break;
							case 46:	i = 170; break;
							case 48:	i = 163; break;
							case 50:	i = 157; break;
						}	
						
						lcd_gotoxy(0,0); lcd_puts("fswitch   ");
						lcd_puti(i); lcd_puts("kHz");
						lcd_gotoxy(0,1); lcd_puts("                ");
						break;
				
				case 4:	// show PFC temperature and Hbridge temperature
						lcd_gotoxy(0,0); lcd_puts("Tpfc       ");
						if(temp_pfc == 0)	// temperature is below 10 degree
						{
							lcd_puts("<10"); lcd_puts("\xDF"); lcd_puts("C");
						}
						
						else if(temp_pfc == 200)	// temperature is over 99 degree
						{
							lcd_puts(">99"); lcd_puts("\xDF"); lcd_puts("C");
						}
						
						else	// temperature is between 10 and 99 degree
						{
							lcd_puts(" "); lcd_puti(temp_pfc);
							lcd_puts("\xDF"); lcd_puts("C");
						}
						
						
						lcd_gotoxy(0,1); lcd_puts("Thbridge   ");
						if(temp_hbridge == 0)	// temperature is below 10 degree
						{
							lcd_puts("<10"); lcd_puts("\xDF"); lcd_puts("C");
						}
						
						else if(temp_hbridge == 200)	// temperature is over 99 degree
						{
							lcd_puts(">99"); lcd_puts("\xDF"); lcd_puts("C");
						}
						
						else	// temperature is between 10 and 99 degree
						{
							lcd_puts(" "); lcd_puti(temp_hbridge);
							lcd_puts("\xDF"); lcd_puts("C");
						}
						
						break;
				
				case 5:	// show chassis temperature
						lcd_gotoxy(0,0); lcd_puts("Tchassis   ");
						if(temp_chassis == 0)	// temperature is below 10 degree
						{
							lcd_puts("<10"); lcd_puts("\xDF"); lcd_puts("C");
						}
						
						else if(temp_chassis == 200)	// temperature is over 99 degree
						{
							lcd_puts(">99"); lcd_puts("\xDF"); lcd_puts("C");
						}
						
						else	// temperature is between 10 and 99 degree
						{
							lcd_puts(" "); lcd_puti(temp_chassis);
							lcd_puts("\xDF"); lcd_puts("C");
						}
						lcd_gotoxy(0,1); lcd_puts("                ");
						break;
			}	// switch(menu_selection)
		}	// else
	} // else
}



// This function checks if all parameters are within range.
// If a fault is present, the return value is 0, otherwise it is 1.
unsigned int check_status(void)
{
	static signed int error_voltage_output_high=0;
	static signed int error_voltage_mains_low=0;
	static signed int error_voltage_mains_high=0;
	static signed int error_voltage_pfc_low=0;
	static signed int error_voltage_pfc_high=0;
	static signed int error_temp_chassis_high=0;
	static signed int error_temp_pfc_high=0;	
	static signed int error_temp_hbridge_high=0;
	static signed int error_current_output_high=0;
	
	// Check if all parameters are within range

	// If one of the parameter s below is 10 times in a row out
	// of range, a flag is set to disable the power supply and
	// show an error message.
	// This function is executed every 100ms, so the parameter has
	// to be out of range for 1s to activate the shutdown of the supply.
	// output voltage:	< 15.0V
	// temperatures:	< 65 degree
	// mains voltage:	> 85V, < 265V
	// PFC voltage:		> 385V, < 400V
	//	11:	output voltage too high
	//	12: mains voltage too low
	//	13: mains voltage too high
	//	14: PFC voltage too low
	//	15: PFC voltage too high
	//	16: chassis temperature too low
	//	17: PFC heatsink temperature too high
	//	18: Hbridge heatsink temperature too high

	// The maximum output current is limited to 25A continuously
	// due to the thermal interface. The power stage itself could
	// deliver much more power. To protect the power stage but to
	// deliver a bit more current for short peaks, an additional
	// monitoring is implemented. The supply can deliver 26A for 2s,
	// after that, it is switched of and a message is shown.
	// output current:	< 26A
	//	19: output current too high


	if(voltage_output > 149)
	{
		error_voltage_output_high++;
		
		if(error_voltage_output_high > 9)
		{
			status_supply = 11;				// set error
		}
	}
	else
	{
		error_voltage_output_high--;
		
		if(error_voltage_output_high < 0)	// limit to 0
		{
			error_voltage_output_high = 0;
		}
	}
	
	
	if(voltage_mains < 85)
	{
		error_voltage_mains_low++;
		
		if(error_voltage_mains_low > 9)
		{
			status_supply = 12;				// set error
		}
	}
	else
	{
		error_voltage_mains_low--;
		
		if(error_voltage_mains_low < 0)		// limit to 0
		{
			error_voltage_mains_low = 0;
		}
	}
	
	// If the voltage is 1000, a I2C fault is present.
	// In this case the supply should not be disabled.
	if( (voltage_mains > 265) && (voltage_mains != 1000) )
	{
		error_voltage_mains_high++;
		
		if(error_voltage_mains_high > 9)
		{
			status_supply = 13;				// set error
		}
	}
	else
	{
		error_voltage_mains_high--;
		
		if(error_voltage_mains_high < 0)	// limit to 0
		{
			error_voltage_mains_high = 0;
		}
	}
	
	
	if(voltage_pfc < 385)
	{
		error_voltage_pfc_low++;
		
		if(error_voltage_pfc_low > 9)
		{
			status_supply = 14;				// set error
		}
	}
	else
	{
		error_voltage_pfc_low--;
		
		if(error_voltage_pfc_low < 0)		// limit to 0
		{
			error_voltage_pfc_low = 0;
		}
	}
	
	
	// If the voltage is 1000, a I2C fault is present.
	// In this case the supply should not be disabled.
	if( (voltage_pfc > 400) && (voltage_pfc != 1000) )
	{
		error_voltage_pfc_high++;
		
		if(error_voltage_pfc_high > 9)
		{
			status_supply = 15;				// set error
		}
	}
	else
	{
		error_voltage_pfc_high--;
		
		if(error_voltage_pfc_high < 0)		// limit to 0
		{
			error_voltage_pfc_high = 0;
		}
	}
	
	
	if(temp_chassis > 65)
	{
		error_temp_chassis_high++;
		
		if(error_temp_chassis_high > 9)
		{
			status_supply = 16;				// set error
		}
	}
	else
	{
		error_temp_chassis_high--;
		
		if(error_temp_chassis_high < 0)		// limit to 0
		{
			error_temp_chassis_high = 0;
		}
	}
	
	
	if(temp_pfc > 65)
	{
		error_temp_pfc_high++;
		
		if(error_temp_pfc_high > 9)
		{
			status_supply = 17;				// set error
		}
	}
	else
	{
		error_temp_pfc_high--;
		
		if(error_temp_pfc_high < 0)			// limit to 0
		{
			error_temp_pfc_high = 0;
		}
	}
	
	
	if(temp_hbridge > 65)
	{
		error_temp_hbridge_high++;
		
		if(error_temp_hbridge_high > 9)
		{
			status_supply = 18;				// set error
		}
	}
	else
	{
		error_temp_hbridge_high--;
		
		if(error_temp_hbridge_high < 0)		// limit to 0
		{
			error_temp_hbridge_high = 0;
		}
	}


	if(current_output > 260)
	{
		error_current_output_high++;

		if(error_current_output_high > 19)	// 2s! (1s for all other parameters)
		{
			status_supply = 19;				// set error
		}
	}
	else
	{
		error_current_output_high--;

		if(error_current_output_high < 0)		// limit to 0
		{
			error_current_output_high = 0;
		}
	}

	// Fault present: return 0, otherwise return 1
	if(status_supply > 10)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}
